<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/Units">

<HTML>
<HEAD>
<link rel="stylesheet" type="text/css" href="Query\ltm.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

    <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" align="center" colspan="2">
        Unit Information for <xsl:value-of select="GetUnit/ICNum"/>
        </td>
      </tr>
      <tr>  
        <td>Load</td>
        <td><xsl:value-of select="GetUnit/LoadNum"/></td>
      </tr>
      <tr>  
        <td>Supplier</td>
        <td><xsl:value-of select="GetUnit/SupplierName"/></td>
      </tr>
      <tr>  
        <td>Receipt</td>
        <td><xsl:value-of select="substring(GetUnit/ReceiptDate,1,10)"/></td>
      </tr>
      <tr>  
        <td>Ship Location</td>
        <td><xsl:value-of select="GetUnit/ShipLocationCode"/></td>
      </tr>
      <tr>  
        <td>Unit #</td>
        <td><xsl:value-of select="GetUnit/UnitNum"/></td>
      </tr>
      <tr>  
        <td>Serial</td>
        <td><xsl:value-of select="GetUnit/SerialNum"/></td>
      </tr>
      <tr>  
        <td>KVA</td>
        <td><xsl:value-of select="GetUnit/KVARating"/></td>
      </tr>
      <tr>  
        <td>Type</td>
        <td><xsl:value-of select="GetUnit/UnitType"/></td>
      </tr>
      <tr>  
        <td>Phase</td>
        <td><xsl:value-of select="GetUnit/Phase"/></td>
      </tr>
      <tr>  
        <td>Manu</td>
        <td><xsl:value-of select="GetUnit/ManufacturerNum"/></td>
      </tr>
      <tr>  
        <td>Lab</td>
        <td><xsl:value-of select="GetUnit/ExternalLabNum"/></td>
      </tr>
      <tr>  
        <td>PPM</td>
        <td><xsl:value-of select="GetUnit/PPM"/></td>
      </tr>
      <tr>  
        <td>Fluid</td>
        <td><xsl:value-of select="GetUnit/FluidLevel"/></td>
      </tr>
      <tr>  
        <td>MWarehouse</td>
        <td><xsl:value-of select="GetUnit/MWarehouse"/></td>
      </tr>
      <tr>  
        <td>Received</td>
        <td><xsl:value-of select="substring(GetUnit/ReceivedDate,1,10)"/></td>
      </tr>
      <tr>  
        <td>Facility</td>
        <td><xsl:value-of select="GetUnit/FacilityName"/></td>
      </tr>
      <tr>  
        <td>Coil Type</td>
        <td><xsl:value-of select="GetUnit/CoilType"/></td>
      </tr>
      <tr>  
        <td>Warehouse</td>
        <td><xsl:value-of select="GetUnit/Warehouse"/></td>
      </tr>
      <tr>  
        <td>Stock Code</td>
        <td><xsl:value-of select="GetUnit/StockCode"/></td>
      </tr>
      <tr>  
        <td>Qty On Hand</td>
        <td><xsl:value-of select="GetUnit/QtyOnHand"/></td>
      </tr>

     </table>

<div align="center" id="details">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Date</td>
        <td class="detailhdg2">Type</td>
        <td class="detailhdg1">Job</td>
        <td class="detailhdg2">To</td>
        <td class="detailhdg1">From</td>
        <td class="detailhdg2">Qty</td>
      </tr>

      <xsl:for-each select="GetUnit">
        <tr>
          <td class="detailodd"><xsl:value-of select="substring(EntryDate,1,10)"/></td>
          <td class="detaileven"><xsl:value-of select="DetailType"/></td>
          <td class="detailodd"><xsl:value-of select="Job"/></td>
          <td class="detaileven"><xsl:value-of select="TrnWarehouse"/></td>
          <td class="detailodd"><xsl:value-of select="TrfFromWh"/></td>
          <td class="detaileven"><xsl:value-of select="TrnQty"/></td>
        </tr>
      </xsl:for-each>
    </table>

</div>
     
</div>

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

