<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/PorDetail">

<HTML>
<HEAD>
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" colspan="2">
        <xsl:value-of select="PurchaseOrder"/>
        </td>
      </tr>
      <tr>  
        <td class="subheading"><xsl:value-of select="Supplier"/> - <xsl:value-of select="SupplierName"/></td>
      </tr>
      <tr>  
        <td class="subheading"><xsl:value-of select="OrderStatus"/> - 
            	<xsl:choose>
	          <xsl:when test="OrderStatus = 0">
	             Order in process
	          </xsl:when>
	          <xsl:when test="OrderStatus = 1">
	             Ready for printing
	          </xsl:when>
	          <xsl:when test="OrderStatus = 4">
	             Order Printed
	          </xsl:when>
	          <xsl:when test="OrderStatus = 9">
	             Completed Order
	          </xsl:when>
	          <xsl:when test="OrderStatus = *">
	             Cancelled order
	          </xsl:when>
	          <xsl:otherwise>
	            Unknown
	          </xsl:otherwise>
        </xsl:choose>
        </td>
      </tr>
   </table>
</div>

<div align="center" id="whse">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Stock Code</td>
        <td class="detailhdg2">Description</td>
        <td class="detailhdg1">Ordered</td>
        <td class="detailhdg2">Received</td>
      </tr>

      <xsl:for-each select="PurchaseOrderLine">

        <tr>
          <td class="detailodd"><xsl:value-of select="Merchandise/MStockCode"/></td>
          <td class="detaileven number"><xsl:value-of select="Merchandise/MStockDes"/></td>
          <td class="detailodd number"><xsl:value-of select="Merchandise/MOrderQty"/></td>
          <td class="detaileven number"><xsl:value-of select="Merchandise/MReceivedQty"/></td>
        </tr>

      </xsl:for-each>
    </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

