<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/BinQuery">

<HTML>
<HEAD>
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" colspan="2">
        Bin : <xsl:value-of select="BinInformation/Bin"/>
        </td>
      </tr>
   </table>
</div>

<div align="center" id="whse">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Stock Code</td>
        <td class="detailhdg2">Whse</td>
        <td class="detailhdg1">On Hand</td>
      </tr>

      <xsl:for-each select="BinInformation/StockItem">
        <xsl:if test="Quantity!=0">
          <tr>
            <td class="detailodd"><xsl:value-of select="StockCode" /></td>
            <td class="detaileven"><xsl:value-of select="Warehouse" /></td>
            <td class="detailodd number"><xsl:value-of select='format-number(Quantity,"#")' /></td>
          </tr>
        </xsl:if>
      </xsl:for-each>
    </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

