<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/LotQuery/LotInfo">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">
  <table class="borderall" width="100%" border="0">
    <tr>  
      <td nowrap="on" class="heading" colspan="2">
        <xsl:value-of select="LotJob"/>
      </td>
    </tr>
    <tr>  
      <td class="subheading" colspan="2"><xsl:value-of select="StockCode"/> - <xsl:value-of select="Description"/></td>
    </tr>
  </table>
</div>

<div align="center" id="whse">
  <table width="100%" class="detailbody">
    <tr class="detailhdg2">
      <td class="detailhdg1">Bin</td>
      <td class="detailhdg2">On Hand</td>
      <td class="detailhdg1">Available</td>
      <td class="detailhdg2">Expiry Date</td>
    </tr>

    <xsl:for-each select="LotDetails">
      <xsl:sort select="ExpiryDate"/>
        <tr>
          <td class="detailodd"><xsl:value-of select="Bin"/></td>
          <xsl:choose>
            <xsl:when test="Edited_OrigQtyOnHand">
              <td class="detailodd number"><xsl:value-of select="Edited_OrigQtyOnHand"/></td>
              <td class="detaileven number"><xsl:value-of select="Edited_QtyAvailable"/></td>
            </xsl:when>
            <xsl:otherwise>
              <td class="detailodd number"><xsl:value-of select="QtyOnHand"/></td>
              <td class="detaileven number"><xsl:value-of select="QtyAvailable"/></td>
            </xsl:otherwise>
          </xsl:choose>
          <td class="detaileven"><xsl:value-of select="ExpiryDate"/></td>
        </tr>
    </xsl:for-each>
  </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

