<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\ltm.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

  <table width="100%">

    <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" align="center" colspan="2">
        Load Information for <xsl:value-of select="Load/GetLoad/LoadNum"/>
        </td>
      </tr>
      <tr>  
        <td>Supplier</td>
        <td><xsl:value-of select="Load/GetLoad/SupplierName"/></td>
      </tr>
      <tr>  
        <td>Receipt</td>
        <td><xsl:value-of select="substring(Load/GetLoad/ReceiptDate,1,10)"/></td>
      </tr>
      <tr>  
        <td>Status</td>
        <td><xsl:value-of select="Load/GetLoad/Status"/></td>
      </tr>
      <tr>  
        <td>Facility</td>
        <td><xsl:value-of select="Load/GetLoad/FacilityName"/></td>
      </tr>

     </table>
     
<div align="center" id="details">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Unit</td>
        <td class="detailhdg2">IC</td>
        <td class="detailhdg1">Serial</td>
        <td class="detailhdg2">KVA</td>
        <td class="detailhdg1">Type</td>
        <td class="detailhdg2">Phase</td>
        <td class="detailhdg1">Man.</td>
        <td class="detailhdg2">Ext.</td>
        <td class="detailhdg1">PPM</td>
        <td class="detailhdg2">Fluid</td>
      </tr>

      <xsl:for-each select="Load/GetLoad">
        <tr>
          <td class="detailodd"><xsl:value-of select="UnitNum"/></td>
          <td class="detaileven"><xsl:value-of select="ICNum"/></td>
          <td class="detailodd"><xsl:value-of select="SerialNum"/></td>
          <td class="detaileven"><xsl:value-of select="KVARating"/></td>
          <td class="detailodd"><xsl:value-of select="UnitType"/></td>
          <td class="detaileven"><xsl:value-of select="Phase"/></td>
          <td class="detailodd"><xsl:value-of select="ManufacturerNum"/></td>
          <td class="detaileven"><xsl:value-of select="ExternalLabNum"/></td>
          <td class="detailodd"><xsl:value-of select="PPM"/></td>
          <td class="detaileven"><xsl:value-of select="FluidLevel"/></td>
        </tr>
      </xsl:for-each>
    </table>

</div>
</table>
</div>

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

