<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/LicensePlateQuery/LicensePlate">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" colspan="2">
        </td>
      </tr>
      <tr>  
        <td class="subheading" colspan="2"><xsl:value-of select="Plate"/></td>
      </tr>
   </table>
</div>

<div align="center" id="header">
   <table class="borderall" width="100%" border="0">
       <tr>
          <td class="detailodd">Type</td>
          <td class="detaileven"><xsl:value-of select="Container"/></td>
        </tr>
      <tr>  
        <td class="detailodd">Status</td>
        <td class="detaileven"><xsl:value-of select="Status"/></td>
       </tr>
       <tr>
          <td class="detailodd">Warehouse</td>
          <td class="detaileven"><xsl:value-of select="Warehouse"/></td>
        </tr>
       <tr>
          <td class="detailodd">Bin</td>
          <td class="detaileven"><xsl:value-of select="Bin"/></td>
        </tr>
       <tr>
          <td class="detailodd">Job</td>
          <td class="detaileven"><a href="#job-{Job}"><xsl:value-of select="Job"/></a></td>
        </tr>
       <tr>
          <td class="detailodd">Sales Order</td>
          <td class="detaileven"><a href="#so-{SalesOrder}"><xsl:value-of select="SalesOrder"/></a></td>
       </tr>
       <tr>
          <td class="detailodd">User Defined 1</td>
          <td class="detaileven"><xsl:value-of select="User1"/></td>
       </tr>
       <tr>
          <td colspan="2" align="center"><a href="#lbl-lp={Plate}/type=LICENSE PLATE/code={Container}">Print Label</a></td>
        </tr>
    </table>
</div>     

<div align="center" id="summary">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Stock Code</td>
        <td class="detailhdg2">Quantity</td>
      </tr>

      <xsl:for-each select="Item">

        <tr>
          <td class="detailodd"><a href="#stk-{Stock}"><xsl:value-of select="Stock"/></a></td>
          <td class="detaileven number"><xsl:value-of select="Quantity"/></td>
        </tr>

      </xsl:for-each>
    </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

