<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/LicensePlateQuery">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="subheading" colspan="2">
        License plates containing stock code
        </td>
      </tr>
      <tr>  
        <td class="heading" colspan="2"><xsl:value-of select="StockCode"/></td>
      </tr>
   </table>
</div>

<div align="center" id="summary">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Plate</td>
        <td class="detailhdg2">Quantity</td>
        <td class="detailhdg1">Warehouse</td>
        <td class="detailhdg2">Bin</td>
      </tr>

      <xsl:for-each select="PlateDetail">

        <tr>
          <td class="detailodd"><a href="#lpd-{Plate}"><xsl:value-of select="Plate"/></a></td>
          <td class="detaileven"><xsl:value-of select="Quantity"/></td>
          <td class="detailodd"><xsl:value-of select="Warehouse"/></td>
          <td class="detaileven"><xsl:value-of select="Bin"/></td>
        </tr>

      </xsl:for-each>
    </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

