<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/LicensePlateQuery/LicensePlate">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center" id="header">
   <table class="borderall" width="80%" border="0">
       <tr>
          <td class="detailodd">Sales Order</td>
          <td class="detaileven"><xsl:value-of select="SalesOrder"/></td>
        </tr>
    </table>
</div>     

<div align="center" id="summary">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Plate</td>
        <td class="detailhdg2">Carton</td>
      </tr>

      <xsl:for-each select="Item">

        <tr>
        <td class="detailodd">

          <xsl:choose>
            <xsl:when test="Container = 'ROLL'">
               <a href="#lps-{Plate}"><xsl:value-of select="Plate"/></a>

            </xsl:when>
            <xsl:when test="Container = 'PALLET'">
               <a href="#lpd-{Plate}"><xsl:value-of select="Plate"/></a>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="Plate"/>
            </xsl:otherwise>
          </xsl:choose>
            
          </td>
          <td class="detaileven"><xsl:value-of select="User2"/></td>
          <td class="detailodd"><a href="#lbl-lp={Plate}/type=LICENSE PLATE/code={Container}">Print Label</a></td>
        </tr>

      </xsl:for-each>
    </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

