<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:variable name="empty_string" select="''" />

<xsl:template match="/LicensePlateQuery/LicensePlate">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" colspan="2">
        </td>
      </tr>
      <tr>  
        <td class="subheading" colspan="2"><xsl:value-of select="Plate"/></td>
      </tr>
   </table>
</div>

<div align="center" id="header">
   <table class="borderall" width="100%" border="0">
       <tr>
          <td class="detailodd">Type</td>
          <td class="detaileven"><xsl:value-of select="Container"/></td>
        </tr>
      <tr>  
        <td class="detailodd">Status</td>
        <td class="detaileven"><xsl:value-of select="Status"/>
        <xsl:if test="StatusMessage != $empty_string">
        (<xsl:value-of select="StatusMessage"/>)
        </xsl:if>
        </td>
       </tr>
       <tr>
          <td class="detailodd">Warehouse</td>
          <td class="detaileven"><xsl:value-of select="Warehouse"/></td>
        </tr>
       <tr>
          <td class="detailodd">Bin</td>
          <td class="detaileven"><xsl:value-of select="Bin"/></td>
        </tr>
       <tr>
          <td class="detailodd">Job</td>
          <td class="detaileven"><a href="#job-{Job}"><xsl:value-of select="FormattedJob"/></a></td>
        </tr>
       <tr>
          <td class="detailodd">Sales Order</td>
          <td class="detaileven"><a href="#so-{SalesOrder}"><xsl:value-of select="FormattedSalesOrder"/></a></td>
        </tr>
       <tr>
          <td class="detailodd">Shipment</td>
          <td class="detaileven"><xsl:value-of select="Shipment"/></td>
        </tr>
       <tr>
          <td class="detailodd">Parent</td>
          <td class="detaileven"><a href="#lpd-{Parent}"><xsl:value-of select="Parent"/></a></td>
        </tr>
       <tr>
          <td colspan="2" align="center"><a href="#lbl-lp={Plate}/type=LICENSE PLATE/code={Container}">Print Label</a></td>
        </tr>
       <tr>
          <td colspan="2" align="center"><a href="#vbs-ClosePallet/{Plate},{SalesOrder}/Closing Plate...">Close Pallet</a></td>
        </tr>
    </table>
</div>     

<xsl:if test="Item/PlateDetail">
<div align="center" id="summary">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Members</td>
        <td class="detailhdg2">Print</td>
      </tr>

      <xsl:for-each select="Item/PlateDetail">

        <tr>
          <td class="detailodd"><a href="#lpd-{Plate}"><xsl:value-of select="Plate"/></a></td>
          <td class="detaileven"><a href="#lbl-lp={Plate}/type=LICENSE PLATE/code={Container}">Print Label</a></td>
        </tr>

      </xsl:for-each>
    </table>
</div>     
</xsl:if>

<xsl:if test="Item/StockDetail">
<div align="center" id="summary">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Stock Code</td>
        <td class="detailhdg2">Quantity</td>
        <td class="detailhdg1">Plates</td>
      </tr>

      <xsl:for-each select="Item/StockDetail">

        <tr>
          <td class="detailodd"><a href="#stk-{Stock}"><xsl:value-of select="Stock"/></a></td>
          <td class="detaileven"><xsl:value-of select="format-number(Quantity,'0.##')"/></td>
          <td class="detailodd"><a href="#lpstk-{Stock}">Query</a></td>
        </tr>

      </xsl:for-each>
    </table>
</div>     
</xsl:if>

<div align="center" id="TRACKING">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Action</td>
        <td class="detailhdg2">Date/Time</td>
        <td class="detailhdg1">Employee</td>
        <td class="detailhdg2">Details</td>
      </tr>

      <xsl:for-each select="Tracking/TrackingDetail">

        <tr>
          <td class="detailodd"><xsl:value-of select="Action"/></td>
          <td class="detaileven"><xsl:value-of select="EntryDate"/>&#032;<xsl:value-of select="EntryTime"/></td>
          <td class="detailodd"><xsl:value-of select="Employee"/></td>
          <td class="detaileven"><xsl:value-of select="Details"/></td>
        </tr>

      </xsl:for-each>

    </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

