<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/WipQuery">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="left">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" colspan="2">
        Job : <xsl:value-of select="JobHeader/Job"/>
        </td>
      </tr>
      <tr>  
        <td class="subheading" colspan="2"><xsl:value-of select="JobHeader/JobDescription"/></td>
      </tr>  
      <tr>  
        <td>Stock Code</td><td><xsl:value-of select="JobHeader/StockCode"/></td>
      </tr>  
      <tr>  
        <td>Description</td><td><xsl:value-of select="JobHeader/StockDescription"/></td>
      </tr>  
      <tr>  
        <td>Qty to make</td><td><xsl:value-of select="JobHeader/Edited_QtyToMake"/></td>
      </tr>  
      <tr>  
        <td>Qty made</td><td><xsl:value-of select="JobHeader/Edited_QtyManufactured"/></td>
      </tr>
   </table>
</div>

<xsl:if test="MaterialAlloc">

<div align="center" id="allocs">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Stock Code</td>
        <td class="detailhdg2">Description</td>
        <td class="detailhdg1">Required</td>
        <td class="detailhdg2">Issued</td>
      </tr>

      <xsl:for-each select="MaterialAlloc">

        <tr>
          <td class="detailodd"><a href="#stk-{StockCode}"><xsl:value-of select="StockCode"/></a></td>
          <td class="detaileven number"><xsl:value-of select="StockDescription"/></td>
          <td class="detailodd number"><xsl:value-of select="StockingTotalQtyReqd"/></td>
          <td class="detaileven number"><xsl:value-of select="StockingQtyIssued"/></td>
        </tr>

      </xsl:for-each>
    </table>
</div>     
</xsl:if>


</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

