<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:variable name="empty_string" select="''" />
<xsl:variable name="one" select="'1'" />

<xsl:template match="/Post">
<html>
<head>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</head>
<body>
<xsl:apply-templates/>
</body>
</html>
</xsl:template>

<!-- Start of main section -->

<xsl:template match="PostInvGitWhTransferIn/Item">
<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td colspan="2" class="heading">GIT Warehouse Transfer In</td>
      </tr>
      <tr>  
        <td>GIT Reference</td>
        <td class="detailcell"><xsl:value-of select="Key/GtrReference"/></td>
      </tr>
      <tr>  
        <td>From Whse</td>
        <td class="detailcell"><xsl:value-of select="Key/SourceWarehouse"/></td>
      </tr>
      <tr>  
        <td>To Whse</td>
        <td class="detailcell"><xsl:value-of select="Key/TargetWarehouse"/></td>
      </tr>
      <tr>  
        <td>GIT Line</td>
        <td class="detailcell"><xsl:value-of select="Key/LineNumber"/></td>
      </tr>
      <tr>  
        <td>Quantity</td>
        <td class="detailcell"><xsl:value-of select="Quantity"/></td>
      </tr>
     <xsl:if test="TargetBin != $empty_string">
      <tr>  
        <td>Bin</td>
        <td class="detailcell"><xsl:value-of select="TargetBin"/></td>
      </tr>
     </xsl:if>
     <xsl:if test="Notation != $empty_string">
      <tr>  
        <td>Notation</td>
        <td class="detailcell"><xsl:value-of select="Notation"/></td>
      </tr>
     </xsl:if>
   </table>
</div>
</xsl:template>

<xsl:template match="Errors">
<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td class="heading">Errors</td>
      </tr>
      <xsl:for-each select="Error">
        <tr>
          <td class="detailodd"><xsl:value-of select="Description"/></td>
        </tr>

      </xsl:for-each>
   </table>
</div>
</xsl:template>

<xsl:template match="Warnings">
<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td class="heading">Warnings</td>
      </tr>
      <xsl:for-each select="Warning">
        <tr>
          <td class="detailodd"><xsl:value-of select="Description"/></td>
        </tr>

      </xsl:for-each>
   </table>
</div>
</xsl:template>

</xsl:stylesheet>

