<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/DispatchNoteDetail">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" colspan="2">
        <xsl:value-of select="DispatchNote"/>
        </td>
      </tr>
      <tr>  
        <td class="subheading" colspan="2"><xsl:value-of select="Customer"/> - <xsl:value-of select="CustomerName"/></td>
      </tr>
      <tr>  
        <td class="subheading"><xsl:value-of select="DispatchNoteStatus"/> - 
            	<xsl:choose>
	          <xsl:when test="DispatchNoteStatus = 0">
	             Order in process
	          </xsl:when>
	          <xsl:when test="DispatchNoteStatus = 3">
	             New Dispatch
	          </xsl:when>
	          <xsl:when test="DispatchNoteStatus = 5">
	             Warehouse
	          </xsl:when>
	          <xsl:when test="DispatchNoteStatus = 7">
	             Released for invoice
	          </xsl:when>
	          <xsl:when test="DispatchNoteStatus = 9">
	             Complete
	          </xsl:when>
	          <xsl:when test="DispatchNoteStatus = *">
	             Aborted
	          </xsl:when>
	          <xsl:when test="DispatchNoteStatus = slash">
	             Cancelled
	          </xsl:when>
	          <xsl:otherwise>
	            Unknown
	          </xsl:otherwise>
        </xsl:choose>
        </td>
      </tr>
   </table>
</div>

<div align="center" id="whse">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg1">Stock Code</td>
        <td class="detailhdg2">Description</td>
        <td class="detailhdg1">To Ship</td>
      </tr>

      <xsl:for-each select="DispatchNoteLine">

        <tr>
          <td class="detailodd"><a href="#stk-{Merchandise/MStockCode}"><xsl:value-of select="Merchandise/MStockCode"/></a></td>
          <td class="detaileven number"><xsl:value-of select="Merchandise/MStockDes"/></td>
          <td class="detailodd number"><xsl:value-of select="Merchandise/MQtyToDispatch"/>&#032;<xsl:value-of select="Merchandise/MOrderUom"/></td>
        </tr>

      </xsl:for-each>
    </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

