<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/BinQuery">

<HTML>
<HEAD>
<meta name = "viewport" content = "user-scalable=yes, width=device-width"/> 
<link rel="stylesheet" type="text/css" href="Query\Query.css"/>
</HEAD>
<BODY>

<!-- Start of main heading section -->

<div align="center">

   <table class="borderall" width="100%" border="0">
      <tr>  
        <td nowrap="on" class="heading" colspan="2">
        Bin : <xsl:value-of select="BinInformation/Bin"/>
        </td>
      </tr>
   </table>
</div>

<div align="center" id="StockItem">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2" colspan="3">
        <td class="detailhdg2" colspan="3">Stock codes in this bin</td>
      </tr>
      <tr class="detailhdg2">
        <td class="detailhdg1">Stock Code</td>
        <td class="detailhdg2">Whse</td>
        <td class="detailhdg1">On Hand</td>
        <td class="detailhdg2">Available</td>
      </tr>

      <xsl:for-each select="BinInformation/StockItem">
          <tr>
            <td class="detailodd"><xsl:value-of select="StockCode" /></td>
            <td class="detaileven"><xsl:value-of select="Warehouse" /></td>
            <td class="detailodd number"><xsl:value-of select='format-number(Quantity,"#")' /></td>
            <td class="detaileven number"><xsl:value-of select='format-number(Available,"#")' /></td>
          </tr>
      </xsl:for-each>
    </table>
</div>     

<br/>

<div align="center" id="DefaultBinItem">
  
    <table width="100%" class="detailbody">
      <tr class="detailhdg2">
        <td class="detailhdg2" colspan="3">Stock codes defaulted to this bin</td>
      </tr>
      <tr class="detailhdg2">
        <td class="detailhdg1">Stock Code</td>
        <td class="detailhdg2">Whse</td>
        <td class="detailhdg1">Description</td>
      </tr>

      <xsl:for-each select="BinInformation/DefaultBinItem">
          <tr>
            <td class="detailodd"><xsl:value-of select="StockCode" /></td>
            <td class="detaileven"><xsl:value-of select="Warehouse" /></td>
            <td class="detailodd"><xsl:value-of select="Description" /></td>
          </tr>
      </xsl:for-each>
    </table>
</div>     

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

